/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package test.implementation.interceptor;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

import junit.framework.TestCase;

import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationContext;
import org.jboss.mx.server.ServerConstants;
import org.jboss.mx.service.ServiceConstants;

import test.implementation.interceptor.support.MySharedInterceptor;


/**
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version $Revision: 1.6.2.2 $
 *   
 */
public class SharedInterceptorTEST extends TestCase
   implements ServerConstants, ServiceConstants
{
   public SharedInterceptorTEST(String s)
   {
      super(s);
   }
   
   
   public void testSharedInterceptor() throws Exception
   {
      MBeanServer server = MBeanServerFactory.createMBeanServer();
      
      MySharedInterceptor shared = new MySharedInterceptor();
      
      ObjectName oname = shared.register(server);
      
      assertTrue(server.isRegistered(new ObjectName(
            JBOSSMX_DOMAIN + ":" + "type=Interceptor,name=MySharedInterceptor,ID=0"
      )));
      
      InvocationContext ic = new InvocationContext();
      Invocation i = new Invocation();

      i.addContext(ic);
      i.setType("bloopah");
      
      server.invoke(oname, "invoke",
            new Object[] { i },
            new String[] { Invocation.class.getName() }
      );
      
      assertTrue(i.getType().equals("something"));
   }
   
   public void testIsShared() throws Exception
   {
      MBeanServer server = MBeanServerFactory.createMBeanServer();
      
      MySharedInterceptor shared = new MySharedInterceptor();
      
      assertTrue(shared.isShared() == false);
      
      shared.register(server);
      
      assertTrue(shared.isShared() == true);
   }
   
   public void testLifecycleCallbacks() throws Exception
   {
      MBeanServer server = MBeanServerFactory.createMBeanServer();
      
      MySharedInterceptor shared = new MySharedInterceptor();
      
      assertTrue(shared.isInit == false);
      assertTrue(shared.isStart == false);
      
      ObjectName oname = shared.register(server);
      
      assertTrue(shared.isInit == true);
      assertTrue(shared.isStart == true);
      
      assertTrue(shared.isStop == false);
      assertTrue(shared.isDestroy == false);
      
      server.unregisterMBean(oname);
      
      assertTrue(shared.isStop == true);
      assertTrue(shared.isDestroy = true);
   }
   

   
   
   
}


