/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package test.implementation.interceptor.support;

import org.jboss.mx.interceptor.AbstractSharedInterceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.InvocationException;


/**
 *
 * @author  <a href="mailto:juha@jboss.org">Juha Lindfors</a>.
 * @version $Revision: 1.5.2.1 $ 
 */
public class MySharedInterceptor
   extends AbstractSharedInterceptor
{

   public boolean isInit = false;
   public boolean isStart = false;
   public boolean isStop = false;
   public boolean isDestroy = false;
   
  public MySharedInterceptor()
  {
     super("MySharedInterceptor");
  }

  public Object invoke(Invocation i) throws InvocationException
  {
     i.setType("something");
     
     return super.invoke(i);
  }
  
  public void init() throws Exception
  {
     isInit = true;
  }
  
  public void start()
  {
     isStart = true;
  }
  
  public void stop() throws Exception
  {
     isStop = true;
  }
  
  public void destroy()
  {
      isDestroy = true;   
  }
  
}  


