/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import java.io.Externalizable;

import javax.jms.Destination;

/**
 * Used to Acknowledge sent messages.
 * <p>
 * This class holds the minimum amount of information needed to identify a
 * message to the JMSServer.
 * 
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author David Maplesden (David.Maplesden@orion.co.nz)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.2.8.1 $
 */
public class AcknowledgementRequest implements Externalizable
{
   // Constants -----------------------------------------------------

   /** The serialVersionUID */
   private static final long serialVersionUID = -2227528634302168874L;
   
   // Attributes ----------------------------------------------------

   /** Is it an acknowledgement */
   public boolean isAck;
   /** The destination */
   public Destination destination = null;
   /** The messageID */
   public String messageID = null;
   /** The subscriberId */
   public int subscriberId;
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   
   // Object overrides ----------------------------------------------
   
   public boolean equals(Object o)
   {

      if (!(o instanceof AcknowledgementRequest))
      {
         return false;
      }

      return messageID.equals(((AcknowledgementRequest) o).messageID)
            && destination.equals(((AcknowledgementRequest) o).destination)
            && subscriberId == ((AcknowledgementRequest) o).subscriberId;
   }

   public int hashCode()
   {
      return messageID.hashCode();
   }

   public String toString()
   {
      return "AcknowledgementRequest:" + (isAck ? "ACK" : "NACK") + "," + destination + "," + messageID;
   }

   public void readExternal(java.io.ObjectInput in) throws java.io.IOException
   {
      isAck = in.readBoolean();
      destination = SpyDestination.readDest(in);
      messageID = in.readUTF();
      subscriberId = in.readInt();
   }
   
   // Externalizable implementation ---------------------------------
   
   public void writeExternal(java.io.ObjectOutput out) throws java.io.IOException
   {
      out.writeBoolean(isAck);
      SpyDestination.writeDest(out, destination);
      out.writeUTF(messageID);
      out.writeInt(subscriberId);
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}