/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.mq;

/**
 * Thrown when a message cannot be added to a queue or a subscription
 * because it is full.
 *
 * @author  <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version <tt>$Revision: 1.1.2.2 $</tt>
 */
public class DestinationFullException
   extends SpyJMSException
{
   // Constants -----------------------------------------------------
   
   // Attributes ----------------------------------------------------
   
   /** The text of the message before the nested mangles it */
   protected String text;
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Create a new DestinationFullException
    *
    * @param msg the message text
    */
   public DestinationFullException(final String msg)
   {
      super(msg);
      this.text = msg;
   }
   
   // Public --------------------------------------------------------

   /**
    * Get the message text
    *
    * @return the text
    */
   public String getText()
   {
      return text;
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------
}
