/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */

package org.jboss.mq;

import java.io.Serializable;
import java.util.Properties;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

/**
 * This class implements <code>javax.jms.TopicConnectionFactory</code> and
 * <code>javax.jms.QueueConnectionFactory</code>.
 * 
 * @author Norbert Lataille (Norbert.Lataille@m4x.org)
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="mailto:jason@planet57.com">Jason Dillon</a>
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version <tt>$Revision: 1.5.2.1 $</tt>
 */
public class SpyConnectionFactory
   implements Serializable, ConnectionFactory, QueueConnectionFactory, TopicConnectionFactory, Referenceable
{
   // Constants -----------------------------------------------------

   /** The serialVersionUID */
   static final long serialVersionUID = 3392566934963731105L;

   // Attributes ----------------------------------------------------

   /** The delegate factory */
   protected GenericConnectionFactory factory;

   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------

   /**
    * Create a new SpyConnectionFactory
    *
    * @param factory the delegate factory
    */
   public SpyConnectionFactory(GenericConnectionFactory factory)
   {
      this.factory = factory;
   }

   /**
    * Create a new SpyConnectionFactory
    *
    * @param config the configuration
    */
   public SpyConnectionFactory(Properties config)
   {
      this.factory = new GenericConnectionFactory(null, config);
   }

   // Public --------------------------------------------------------

   // Referenceable implementation ----------------------------------

   public Reference getReference() throws NamingException
   {
      return new Reference("org.jboss.mq.SpyConnectionFactory", new org.jboss.mq.referenceable.ObjectRefAddr("DCF",
            factory),
            "org.jboss.mq.referenceable.SpyConnectionFactoryObjectFactory", null);
   }

   // ConnectionFactory implementation ------------------------------

   public Connection createConnection() throws JMSException
   {
      try
      {
         return new SpyConnection(factory);
      }
      catch (JMSException e)
      {
         throw e;
      }
      catch (Exception e)
      {
         throw new SpyJMSException("Failed to create Connection", e);
      }
   }

   public Connection createConnection(String userName, String password) throws JMSException
   {
      try
      {
         if (userName == null)
            throw new SpyJMSException("Username is null");
         if (password == null)
            throw new SpyJMSException("Password is null");

         return new SpyConnection(userName, password, factory);
      }
      catch (JMSException e)
      {
         throw e;
      }
      catch (Exception e)
      {
         throw new SpyJMSException("Failed to create Connection", e);
      }
   }

   // QueueConnectionFactory implementation -------------------------

   public QueueConnection createQueueConnection() throws JMSException
   {
      return (QueueConnection) createConnection();
   }

   public QueueConnection createQueueConnection(String userName, String password) throws JMSException
   {
      return (QueueConnection) createConnection(userName, password);
   }

   // TopicConnectionFactory implementation -------------------------

   public TopicConnection createTopicConnection() throws JMSException
   {
      return (TopicConnection) createConnection();
   }

   public TopicConnection createTopicConnection(String userName, String password) throws JMSException
   {
      return (TopicConnection) createConnection(userName, password);
   }

   // Package protected ---------------------------------------------

   // Protected -----------------------------------------------------

   // Private -------------------------------------------------------

   // Inner classes -------------------------------------------------
}