/*
 * JBossMQ, the OpenSource JMS implementation
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package org.jboss.mq;

import javax.jms.JMSException;

/**
 * This class defines the interface which is used by the ConnectionReceiver to
 * send messages to the consumers.
 * 
 * @author Hiram Chirino (Cojonudo14@hotmail.com)
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.2.8.1 $
 */
public interface SpyConsumer
{
   // Public --------------------------------------------------------

   /**
    * A ConnectionReceiver uses this method to load a Consumer with a message
    *
    * @param mes the message
    * @throws JMSException for any error
    */
   void addMessage(SpyMessage mes) throws JMSException;

   /**
    * This is used to know what type of messages the consumer wants
    *
    * @return the subscription
    */
   Subscription getSubscription();
   
   // Inner classes -------------------------------------------------
}