/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.mq;

import java.io.PrintWriter;
import java.io.PrintStream;

import javax.transaction.xa.XAException;

import org.jboss.util.NestedThrowable;
import org.jboss.util.NestedException;

/**
 * An XAException with a nested throwable
 * 
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version <tt>$Revision: 1.1.2.2 $</tt>
 */
public class SpyXAException extends XAException implements NestedThrowable
{
   // Constants -----------------------------------------------------

   /** The serialVersionUID */
   static final long serialVersionUID = 7814140228056884098L;
   
   // Attributes ----------------------------------------------------

   /** The nested throwable */
   protected Throwable nested;
   
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------

   /**
    * Construct a <tt>SpyXAException</tt>
    */
   public SpyXAException()
   {
      super();
      this.nested = null;
   }

   /**
    * Construct a <tt>SpyXAException</tt> with the specified detail message.
    * 
    * @param msg Detail message.
    */
   public SpyXAException(final String msg)
   {
      super(msg);
      this.nested = null;
   }

   /**
    * Construct a <tt>SpyXAException</tt> with the specified detail message
    * and error code.
    * 
    * @param code Error code.
    */
   public SpyXAException(final int code)
   {
      super(code);
      this.nested = null;
   }

   /**
    * Construct a <tt>SpyXAException</tt>
    * 
    * @param throwable the nested throwable.
    */
   public SpyXAException(Throwable t)
   {
      super();
      this.nested = t;
   }

   /**
    * Construct a <tt>SpyXAException</tt> with the specified detail message.
    * 
    * @param msg Detail message.
    * @param throwable the nested throwable.
    */
   public SpyXAException(final String msg, Throwable t)
   {
      super(msg);
      this.nested = t;
   }

   /**
    * Construct a <tt>SpyXAException</tt> with the specified detail message
    * and error code.
    * 
    * @param code Error code.
    * @param throwable the nested throwable.
    */
   public SpyXAException(final int code, Throwable t)
   {
      super(code);
      this.nested = t;
   }
   
   // Public --------------------------------------------------------
   
   // NestedException implementation --------------------------------

   public Throwable getNested()
   {
      return nested;
   }
   
   // Throwable overrides -------------------------------------------

   public Throwable getCause()
   {
      return nested;
   }

   public void setLinkedException(final Exception e)
   {
      this.nested = e;
   }

   public Exception getLinkedException()
   {
      //
      // jason: this is bad, but whatever... the jms folks should have had more
      // insight
      //
      if (nested == null)
         return this;
      if (nested instanceof Exception)
        {
         return (Exception) nested;
      }
      return new NestedException(nested);
   }

   public String getMessage()
   {
      return NestedThrowable.Util.getMessage(super.getMessage(), nested);
   }

   public void printStackTrace(final PrintStream stream)
   {
      if (nested == null || NestedThrowable.PARENT_TRACE_ENABLED)
        {
         super.printStackTrace(stream);
      }
      NestedThrowable.Util.print(nested, stream);
   }

   public void printStackTrace(final PrintWriter writer)
   {
      if (nested == null || NestedThrowable.PARENT_TRACE_ENABLED)
        {
         super.printStackTrace(writer);
      }
      NestedThrowable.Util.print(nested, writer);
   }

   public void printStackTrace()
   {
      printStackTrace(System.err);
   }
   
   // Package protected ---------------------------------------------
   
   // Protected -----------------------------------------------------
   
   // Private -------------------------------------------------------
   
   // Inner classes -------------------------------------------------

}