/*
 * JBossMQ, the OpenSource JMS implementation
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.mq.server;

/**
 * Parameters controlling a basic queue
 *
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @version $Revision: 1.1.2.6 $
 */
public class BasicQueueParameters
{
   /** The maximum depth of a queue */
   public int maxDepth = 0;

   /** Whether we should do things in memory (needs support from pm) */
   public boolean inMemory = false;
   
   /** Whether we are late cloning */
   public boolean lateClone = false;

   /** The delay in milliseconds before a rolled back or recovered message is redelivered */
   public long redeliveryDelay = 0;

   /** 
    * The number of times a message will be redelivered after a recover or rollback. 
    * The value <code>-1</code> means there is no configured limit.
    */
   public int redeliveryLimit =-1 ;
   
   /** The receivers implementation class */
   public Class receiversImpl;
   
   /** The message counter history */
   public int messageCounterHistoryDayLimit = -1;
}
