/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;

import org.jboss.logging.Logger;

import java.util.List;
import java.util.Map;

/**
 * Client is a convience method for invoking remote methods for a given subsystem
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @version $Revision: 1.2 $
 */
public interface ClientInterceptor
{

   boolean isConnected (InvokerLocator locator) throws Exception;

   void connect (InvokerLocator locator) throws Exception;

   void disconnect (InvokerLocator locator) throws Exception;


    /**
     * invoke the method remotely
     *
     * @param sessionId
     * @param method
     * @param params
     * @param signature
     * @param sendPayload
     * @return
     * @throws Throwable
     */
    Object invoke (InvocationRequest invocation)
      throws Throwable;

    /**
     * If the client invoker has a client locator, call it to add the client's
     * callback handler.  Then call the server to add a callback handler
     * (regardless of client locator being null).  This will allow for pull or
     * push callbacks.
     * @param callbackHandler
     * @throws Throwable
     */
    void addListener(InvokerLocator locator, String sessionId, InvokerCallbackHandler callbackHandler) throws Throwable;

    /**
     * Removes callback handler as a callback listener from the server (and client in
     * the case that it was setup to receive async callbacks). See addListener().
     * @param callbackHandler
     * @throws Throwable
     */
    void removeListener(InvokerLocator locator, String sessionId, InvokerCallbackHandler callbackHandler) throws Throwable;

    List getCallbacks(InvokerLocator locator, String sessionId) throws Throwable;

}
