/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting;

/**
 *  Invoker represents a local or remote endpoint to a system taht can handle invocations.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 */
public interface Invoker
{
    /**
     * return the locator this Invoker represents
     *
     * @return
     */
    public InvokerLocator getLocator ();

    /**
     * called when the invoker is no longer to be used and should release all internal resources
     */
    public void destroy ();

    /**
     * returns true if destroyed, false is not  (regardless of the connection state)
     *
     * @return
     */
    public boolean isDestroyed ();


}