/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;

import javax.management.MBeanServer;


/**
 * ServerInvocationHandler is the server side (remote) end handler which is registered for a given
 * ServerInvoker implementation.  The ServerInvocationHandler does the actual implementation work
 * of invoking the method on the target object in the remote VM.  The ServerInvoker will then
 * handle marshalling and returning the results via the appropriate transport back to the client invoker.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 * @version $Revision: 1.3.4.1 $
 */
public interface ServerInvocationHandler
{
    /**
     * set the mbean server that the handler can reference
     *
     * @param server
     */
    public void setMBeanServer (MBeanServer server);

    /**
     * set the invoker that owns this handler
     *
     * @param invoker
     */
    public void setInvoker (ServerInvoker invoker);

    /**
     * called to handle a specific invocation
     *
     * @param invocation
     * @return
     * @throws Throwable
     */
    public Object invoke (InvocationRequest invocation)
            throws Throwable;

    /**
     * Adds a callback handler that will listen for callbacks from
     * the server invoker handler.
     * @param callbackHandler
     */
    public void addListener(InvokerCallbackHandler callbackHandler);

    /**
     * Removes the callback handler that was listening for callbacks
     * from the server invoker handler.
     * @param callbackHandler
     */
    public void removeListener(InvokerCallbackHandler callbackHandler);

    /**
     * called to destroy the handler
     */
    public void destroy ();

}
