/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting;

/**
 * Predefined subsystem types.  These are strings since you could support a proprietary
 * subsystem or new specification by just adding the new subsystem string name on the server/client.
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1 $
 */
public interface Subsystem
{
    // special subsystem defined as self, which is the transport layer - used when the transport
    // wants to send messages to itself, such as ping, synching data on both sides, etc. which
    // don't actually get propograted up the transport layer
    public static final String SELF = "self";

    public static final String JMX = "jmx";
    public static final String JMS = "jms";
    public static final String EJB = "ejb";
    public static final String RMI = "rmi";
}
