package org.jboss.remoting.detection;

import org.w3c.dom.Element;

/**
 * This provides a MBean accessible interface for setting domain configuration
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public interface AbstractDetectorMBean
{
    /**
     * set the configuration for the domains to be recognized by detector
     *
     * @param xml
     *
     * @jmx.managed-attribute description="Domains is an xml element indicating domains to be recognized by detector"
     *     access="read-write"
     */
    public void setConfiguration(Element xml) throws Exception;

    /**
     * The <code>getDomains</code> method
     *
     * @return an <code>Element</code> value
     *
     * @jmx.managed-attribute
     */
    public Element getConfiguration();

    /**
     * Will add the specified domain to the list of domains that the
     * detector will look for when doing detection.
     *
     * @param domainName
     */
    public void addDomain(String domainName);

    /**
     * Will remove the specified domain from the list of domains that the
     * detector will look for when doing detection.  Note, this will
     * cause servers already found by the detector to be invalidated and will
     * appear as though they have gone down.
     *
     * @param domainName
     */
    public void removeDomain(String domainName);

}
