/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */

package org.jboss.remoting.invocation;

/**
 * NameBasedInvocation.java is an invocation object in jmx style.
 * <p/>
 * <p/>
 * Created: Mon Apr 28 09:14:46 2003
 *
 * @author <a href="mailto:d_jencks@users.sourceforge.net">David Jencks</a>
 * @version 1.0
 */
public class NameBasedInvocation extends RemoteInvocation
{

   private final String[] sig;

   public NameBasedInvocation(final String methodName, final Object[] params, final String[] sig)
   {
      super(methodName, params);
      this.sig = sig;
   } // NameBasedInvocation constructor

   public String[] getSignature()
   {
      return sig;
   }

   public String toString()
   {
      return "NameBasedInvocation [" + methodName + "]";
   }

} // NameBasedInvocation
