/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.loading;

/**
 * ClassBytes is a serialized object that represents a class name and the class bytes as a byte array.
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1 $
 */
public class ClassBytes implements java.io.Serializable
{
    static final long serialVersionUID = 9163990179051656161L;
    protected String className;
    protected byte classBytes[];

    public ClassBytes (String className, byte data[])
    {
        this.className = className;
        this.classBytes = data;
    }
    public String toString ()
    {
        return "ClassBytes [class="+className+",value="+classBytes+"]";
    }
    public String getClassName ()
    {
        return className;
    }
    public byte[] getClassBytes ()
    {
        return classBytes;
    }
}
