/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.loading;

import org.jboss.remoting.RemoteMethodInvocation;

/**
 * ClassRequestedMethodInvocationResult is sent back with a class bytes that was required and the original
 * invocation to be re-invoked with the new class bytes.
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1 $
 */
public class ClassRequestedMethodInvocationResult extends org.jboss.remoting.RemoteMethodInvocationResult
{
    static final long serialVersionUID = -1523959117367652488L;
    private final ClassBytes classBytes;
    private final RemoteMethodInvocation originalInvocation;

    public ClassRequestedMethodInvocationResult (String sessionId,ClassBytes classBytes, RemoteMethodInvocation originalInvocation)
        throws java.io.IOException
    {
        super(sessionId,null,false,(originalInvocation==null?null:originalInvocation.getPayload()));
        this.classBytes = classBytes;
        this.originalInvocation = originalInvocation;
    }
    public org.jboss.remoting.loading.ClassBytes getRequestedClass ()
    {
        return classBytes;
    }
    public org.jboss.remoting.RemoteMethodInvocation getOriginalInvocation ()
    {
        return originalInvocation;
    }
}
