/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.loading;

import java.io.IOException;

import org.jboss.remoting.RemoteMethodInvocation;
import org.jboss.remoting.Subsystem;
import org.jboss.remoting.InvokerLocator;

/**
 * ClassRequiredMethodInvocation is sent when a class is required for invocation.
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.3 $
 */
public class ClassRequiredMethodInvocation extends RemoteMethodInvocation
{
   //static final long serialVersionUID = -8719183945316765386L;

   public ClassRequiredMethodInvocation (String sessionId, String className, InvokerLocator l)
      throws IOException
   {
      super(sessionId, Subsystem.SELF, className, null, l);
   }

   public String getClassRequiredName() throws IOException, ClassNotFoundException
   {
      ClassBytes bytes = getParameter();
      byte[] data = bytes.getClassBytes();
      return (String)ClassUtil.deserialize(data);
   }
}
