/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.network;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;

/**
 * NetworkRegistryQuery is a QueryExp that will filter on NetworkRegistryMBean mbeans.
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1 $
 */
public class NetworkRegistryQuery implements QueryExp
{
    private MBeanServer server;

    public boolean apply ( ObjectName objectName ) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException
    {
        try
        {
            return server.isInstanceOf(objectName,NetworkRegistryMBean.class.getName());
        }
        catch ( InstanceNotFoundException e )
        {
        }
        return false;
    }

    public void setMBeanServer ( MBeanServer mBeanServer )
    {
        this.server = mBeanServer;
    }
}
