/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.mock;

import java.io.IOException;
import java.io.InputStream;

import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;

/**
 * MockClientInvoker
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.4 $
 */
public class MockClientInvoker extends RemoteClientInvoker
{
    private final MockServerInvoker server;
    private boolean loaded=false;

    public MockClientInvoker (InvokerLocator locator, MockServerInvoker server)
    {
        super(locator);
        this.server=server;
    }

    /**
     * subclasses must implement this method to provide a hook to connect to the remote server, if this applies
     * to the specific transport. However, in some transport implementations, this may not make must difference since
     * the connection is not persistent among invocations, such as SOAP.  In these cases, the method should
     * silently return without any processing.
     *
     * @throws ConnectionFailedException
     */
    protected void handleConnect ()
            throws ConnectionFailedException
    {
    }

    /**
     * subclasses must implement this method to provide a hook to disconnect from the remote server, if this applies
     * to the specific transport. However, in some transport implementations, this may not make must difference since
     * the connection is not persistent among invocations, such as SOAP.  In these cases, the method should
     * silently return without any processing.
     */
    protected void handleDisconnect ()
    {
    }

    public byte[] getClassBytes (String className)
    {
        // this is just a test to dynamically load a class
        if (className.equals("FooBar") && loaded==false)
        {
            InputStream in = null;
            try
            {
                String packageName = org.jboss.remoting.loading.ClassUtil.getPackageName(getClass());
                String name = packageName.replace('.','/')+"/test/FooBar.xclass";
                log.debug("attempting to load FooBar from: "+name);
                in = this.getClass().getClassLoader().getResourceAsStream(name);
                if (in!=null)
                {
                    byte buf[]=read(in);
                    addClass(new org.jboss.remoting.loading.ClassBytes(className,buf));
                    loaded=true;
                    return buf;
                }
            }
            catch (IOException e)
            {

            }
            finally
            {
                if (in!=null)
                {
                    try { in.close(); } catch (Exception ig) {}
                    in=null;
                }
            }
        }
        return super.getClassBytes(className);
    }

    public void connect ()
            throws ConnectionFailedException
    {
    }

    public void disconnect ()
    {
    }

    public boolean isConnected ()
    {
        return false;
    }


    protected byte[] transport (String sesionId, byte buffer[])
            throws IOException
    {
        return server.invoke(buffer);
    }
}
