/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.mock;

import java.io.IOException;
import java.io.InputStream;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
/**
 * MockServerInvoker
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.3 $
 */
public class MockServerInvoker extends ServerInvoker
{
    boolean loaded=false;

    public MockServerInvoker (InvokerLocator locator)
    {
       super(locator);
    }

    /**
     * returns true if the transport is bi-directional in nature, for example,
     * SOAP in unidirectional and SOCKETs are bi-directional (unless behind a firewall
     * for example).
     *
     * @return
     */
    public boolean isTransportBiDirectional ()
    {
        return false;
    }

    public byte[] getClassBytes (String className)
    {
        // this is just a test to dynamically load a class
        if (className.equals("Bar") && loaded==false)
        {
            InputStream in = null;
            try
            {
                String packageName = org.jboss.remoting.loading.ClassUtil.getPackageName(getClass());
                String name = packageName.replace('.','/')+"/test/Bar.xclass";
                log.debug("attempting to load Bar from: "+name);
                in = this.getClass().getClassLoader().getResourceAsStream(name);
                if (in!=null)
                {
                    byte buf[]=read(in);
                    addClass(new org.jboss.remoting.loading.ClassBytes(className,buf));
                    loaded=true;
                    return buf;
                }
            }
            catch (IOException e)
            {

            }
            finally
            {
                if (in!=null)
                {
                    try { in.close(); } catch (Exception ig) {}
                    in=null;
                }
            }
        }

        return super.getClassBytes(className);
    }
}
