/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.rmi.RemoteException;

import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;

/**
 * RMIClientInvoker
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @author <a href="mailto:telrod@vocalocity.net">Tom Elrod</a>
 * @version $Revision: 1.4 $
 */
public class RMIClientInvoker extends RemoteClientInvoker
{
    private RMIServerInvokerInf server;

    public RMIClientInvoker (InvokerLocator locator)
    {
        super(locator);
    }

    /**
     * get the server stub
     *
     * @param server
     */
    public void setServerStub (RMIServerInvokerInf server)
    {
        this.server = server;
        System.err.println(this.server);
    }

    /**
     * return the RMI server stub
     *
     * @return
     */
    public RMIServerInvokerInf getServerStub ()
    {
        return this.server;
    }

    /**
     * subclasses must implement this method to provide a hook to connect to the remote server, if this applies
     * to the specific transport. However, in some transport implementations, this may not make must difference since
     * the connection is not persistent among invocations, such as SOAP.  In these cases, the method should
     * silently return without any processing.
     *
     * @throws ConnectionFailedException
     */
    protected void handleConnect ()
            throws ConnectionFailedException
    {
    }

    /**
     * subclasses must implement this method to provide a hook to disconnect from the remote server, if this applies
     * to the specific transport. However, in some transport implementations, this may not make must difference since
     * the connection is not persistent among invocations, such as SOAP.  In these cases, the method should
     * silently return without any processing.
     */
    protected void handleDisconnect ()
    {
    }

    protected byte[] transport (String sessionId, byte buffer[])
            throws IOException, ConnectionFailedException
    {
        if (this.server==null)
        {
            throw new IOException("Server stub hasn't been set!");
        }
        try
        {
            return server.transport(buffer);
        }
        catch (RemoteException e)
        {
            throw new ConnectionFailedException(e.getMessage());
        }
    }
}
