/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;

/**
 * RMIServerInvoker
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.3 $
 */
public class RMIServerInvoker extends ServerInvoker implements RMIServerInvokerInf
{
    private final RemoteStub stub;

    public RMIServerInvoker (InvokerLocator locator)
        throws RemoteException
    {
        super(locator);
        if (locator.getPort()!=-1)
        {
           stub = (RemoteStub)UnicastRemoteObject.exportObject(this,locator.getPort());
        }
        else
        {
            stub = UnicastRemoteObject.exportObject(this);
        }
    }
    /**
     * destroy the RMI Server Invoker, which will unexport the RMI server
     */
    public void destroy ()
    {
        try
        {
            UnicastRemoteObject.unexportObject(this,true);
        }
        catch (java.rmi.NoSuchObjectException e)
        {

        }
    }
    protected void finalize () throws Throwable
    {
        destroy();
        super.finalize();
    }

    /**
     * returns true if the transport is bi-directional in nature, for example,
     * SOAP in unidirectional and SOCKETs are bi-directional (unless behind a firewall
     * for example).
     *
     * @return
     */
    public boolean isTransportBiDirectional ()
    {
        return true;
    }

    public final RemoteStub getStub ()
    {
        return stub;
    }

    public byte[] transport (byte buffer[])
            throws RemoteException, IOException
    {
        return invoke(buffer);
    }
}
