/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * RMIServerInvokerInf
 * 
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision: 1.1 $
 */
public interface RMIServerInvokerInf extends Remote
{
    /**
     * transport a buffer via RMI
     *
     * @param buffer
     * @return
     * @throws RemoteException
     * @throws IOException
     */
    public byte[] transport (byte buffer[])
        throws RemoteException, IOException;
}
