/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.jboss.logging.Logger;

import java.util.Iterator;
import java.util.List;

/**
 * Extends regular JUnit TestResult so can run multiple test methods
 * within a single TestCase class.
 * @see MultipleTestCase
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class MultipleTestResult extends TestResult
{
    private static final Logger log = Logger.getLogger(MultipleTestResult.class);

    protected void run(final TestCase test)
    {
        if(test instanceof MultipleTestCase)
        {
            startTest(test);

            MultipleTestCase mTest = (MultipleTestCase) test;
            List testMethods = mTest.getTestMethods();
            Iterator itr = testMethods.iterator();
            while(itr.hasNext())
            {
                try
                {
                    String methodName = (String) itr.next();
                    log.debug("running test method " + methodName);
                    mTest.runBare(methodName);
                }
                catch(AssertionFailedError e)
                {
                    addFailure(test, e);
                }
                catch(ThreadDeath e)
                { // don't catch ThreadDeath by accident
                    throw e;
                }
                catch(Throwable e)
                {
                    addError(test, e);
                }
            }
            endTest(test);

        }
        else
        {
            super.run(test);
        }
    }

}