/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.classloading;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.jgroups.Address;
import test.DistributedTestCase;
import test.InvokerClientTest;
import test.classloading.server.InvokerServerNoSecurityTest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This should be used as the main test case for the invoker client/server.
 * It will start one instance of the client and one of the server and will
 * gather the test results and report them in standard JUnit format.  When
 * wanting to run JUnit test for invoker, this is the class to use.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class InvokerTestCase extends DistributedTestCase
{
   private List results = new ArrayList();

   public InvokerTestCase(String name)
   {
      super(name);
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);
      Logger log = Logger.getLogger(getClass());

   }

   protected void setUp() throws Exception
   {
      String clientcmd = "java -cp " + System.getProperty("java.class.path") +
//                          " -Djboss.mx.instanceid.dir=" + System.getProperty("jboss.mx.instanceid.local.dir") +
            " " + InvokerClientTest.class.getName() + " 3";
      System.out.println("clientcmd: " + clientcmd);
      String svrcmd = "java -cp " + System.getProperty("java.class.path") +
//                          " -Djboss.mx.instanceid.dir=" + System.getProperty("jboss.mx.instanceid.remote.dir") +
            " " + InvokerServerNoSecurityTest.class.getName() + " 3";
      System.out.println("svrcmd: " + svrcmd);

      final Process local = Runtime.getRuntime().exec(clientcmd);
      final Process remote = Runtime.getRuntime().exec(svrcmd);
   }

   protected void tearDown() throws Exception
   {
      //NO OP since manually controlling shutdown
   }

   public void testInvokers()
   {
      try
      {
         startup(3);
         System.out.println("startup() called");
         shutdown();
         System.out.println("shutdown() called");
      }
      catch (Exception e)
      {
         //TODO:DEBUG -TME
         e.printStackTrace();
      }
      finally
      {
         // assert results
         try
         {
            Thread.currentThread().sleep(5000);
         }
         catch (InterruptedException e)
         {
            e.printStackTrace();
         }
         System.out.println("results.size() = " + results.size());
         if (results.size() > 0)
         {
            Iterator itr = results.iterator();
            while (itr.hasNext())
            {
               String message = (String) itr.next();
               assertTrue(message, false);
            }
         }
         else
         {
            assertTrue("No test failures or errors.", true);
         }

      }
   }

   /**
    * **********************************
    * Driver callback for JUnit asserts *
    * ***********************************
    */
   public void receiveAssert(Address source, String message)
   {
      super.receiveAssert(source, message);
      results.add("Assert source: " + source + "\tmessage: " + message);
   }

   public static Test suite()
   {
      return new TestSuite(InvokerTestCase.class);
   }

   public static void main(String[] args)
   {
      TestRunner.run(suite());
      System.exit(0);
   }


}