/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.classloading.server;

import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class InvokerServerSecureTest extends InvokerServerNoSecurityTest
{
   private static final Logger log = Logger.getLogger(InvokerServerSecureTest.class);

   public InvokerServerSecureTest(String name)
   {
      super(name);
   }

   public InvokerServerSecureTest(int instances)
   {
      super(instances);
   }

   public InvokerServerSecureTest(String transport, int port)
   {
      super(transport, port);
   }

   public InvokerServerSecureTest(String transport, int port, int instances)
   {
      super(transport, port, instances);
   }

   protected Element getServerConfiguration()
   {
      Element serverConfig = null;

      try
      {
         StringBuffer buf = new StringBuffer();
         buf.append("<?xml version=\"1.0\"?>\n");
         buf.append("<server_config>\n");
         buf.append("<handlers>\n");
         buf.append("<handler subsystem=\"mock\">org.jboss.remoting.transport.mock.MockServerInvocationHandler</handler>\n");
         buf.append("</handlers>");
         buf.append("</server_config>");
         System.out.println("Server config:\n" + buf);
         Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
         serverConfig = xml.getDocumentElement();
      }
      catch (SAXException e)
      {
         e.printStackTrace();
      }
      catch (IOException e)
      {
         e.printStackTrace();
      }
      catch (ParserConfigurationException e)
      {
         e.printStackTrace();
      }

      return serverConfig;
   }

   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);

      //DEBUG for server -TME
      System.setProperty("jboss.remoting.invoker.debug", "true");

      InvokerServerSecureTest server = null;
      if (args.length == 1)
      {
         int instances = Integer.parseInt(args[0]);
         server = new InvokerServerSecureTest(instances);
      }
      else if (args.length == 2)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         server = new InvokerServerSecureTest(transport, port);
      }
      else if (args.length == 3)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         int instances = Integer.parseInt(args[2]);
         server = new InvokerServerSecureTest(transport, port, instances);
      }
      else
      {
         server = new InvokerServerSecureTest(InvokerServerSecureTest.class.getName());
         System.out.println("Using default transport (" + server.getTransport() +
               ") and default port (" + server.getPort() + ") and " +
               "default number of instances (" + server.getNumberOfInstances() + ")" +
               "\nCan enter transport, port, and instances via command line.");
      }

      try
      {
         server.serverTest();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }


}