/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.detection.jndi;

import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.detection.jndi.JNDIDetector;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transport.Connector;
import org.jnp.server.Main;
import org.w3c.dom.Document;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.ByteArrayInputStream;
import java.util.Random;

import test.DistributedTestCase;

/**
 * Just tests that detector A sees detector B when B comes online then off.
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class JNDIDetectorTest2 extends DistributedTestCase
{
    // Setup for JNDI Server
    private int detectorPort = 1099;
    private String detectorHost = "localhost";
    private String contextFactory = "org.jnp.interfaces.NamingContextFactory";
    private String urlPackage = "org.jboss.naming:org.jnp.interfaces";

    public JNDIDetectorTest2(String name)
    {
        super(name);
    }

    public JNDIDetectorTest2(String name, int port, String host)
    {
        super(name);
        this.detectorPort = port;
        this.detectorHost = host;
    }

    public JNDIDetectorTest2(int instances, int port, String host)
    {
        super("JNDIDetectorTest2");
        this.detectorPort = port;
        this.detectorHost = host;
        init(instances);
    }


        public int getDetectorPort()
    {
        return detectorPort;
    }

    public void setDetectorPort(int detectorPort)
    {
        this.detectorPort = detectorPort;
    }

    public String getDetectorHost()
    {
        return detectorHost;
    }

    public void setDetectorHost(String detectorHost)
    {
        this.detectorHost = detectorHost;
    }
    public void testDetectors()
    {
        try
        {

            JNDIDetector detector = new JNDIDetector();
            detector.setCleanDetectionNumber(2);

            Connector connector = new Connector();

            NetworkRegistry reg = setupServers(detector, connector);

            startup();

            // sleep for a few seconds so the 1st detector can discover 2nd one down
            Thread.currentThread().sleep(4000);

            // stop the 2nd detector, so see if 1st one detects it is missing
            connector.stop();
            //connector.destroy();
            connector = null;
            detector.stop();
            detector = null;

            Thread.currentThread().sleep(10000);

            shutdown();

        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }


    private synchronized NetworkRegistry setupServers(JNDIDetector detector, Connector connector)
    {
        NetworkRegistry registry = null;
        System.setProperty("jboss.identity", String.valueOf(System.currentTimeMillis()));
        System.out.println("jboss.identity = " + System.getProperty("jboss.identity"));

        try
        {
            MBeanServer server = MBeanServerFactory.createMBeanServer();

            //registry = NetworkRegistry.getInstance();
            registry = TestNetworkRegistry.createNetworkRegistry();
            server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));

            int port = Math.abs(new Random().nextInt(2000));
            System.out.println("port = " + port);

            InvokerLocator locator = new InvokerLocator("socket://localhost:" + port);
            StringBuffer buf = new StringBuffer();
            buf.append("<?xml version=\"1.0\"?>\n");
            buf.append("<handlers>\n");
            buf.append("  <handler subsystem=\"mock\">org.jboss.remoting.transport.mock.MockServerInvocationHandler</handler>\n");
            buf.append("</handlers>\n");
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(buf.toString().getBytes()));
            connector.setInvokerLocator(locator.getLocatorURI());
            connector.setConfiguration(xml.getDocumentElement());
            ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + locator.getProtocol());
            server.registerMBean(connector, obj);
            //connector.create();
            connector.start();

            //Need to set new domain for identity
            server.registerMBean(detector, new ObjectName("remoting:type=JNDIDetector"));

            // set config info for detector and start it.
            detector.setPort(detectorPort);
            detector.setHost(detectorHost);
            detector.setContextFactory(contextFactory);
            detector.setURLPackage(urlPackage);
            detector.start();
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }

        return registry;
    }

    public static void main(String[] args)
    {
        org.apache.log4j.BasicConfigurator.configure();
        org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);

        JNDIDetectorTest2 test = null;
        if(args.length == 2)
        {
            String sPort = args[0];
            int port = Integer.parseInt(sPort);
            String host = args[1];
            test = new JNDIDetectorTest2("JNDIDetectorTest2", port, host);
        }
        else if(args.length == 3)
        {
            String sInstances = args[0];
            int instances = Integer.parseInt(sInstances);
            String sPort = args[1];
            int port = Integer.parseInt(sPort);
            String host = args[2];
            test = new JNDIDetectorTest2(instances, port, host);
        }
        else
        {
            test = new JNDIDetectorTest2("JNDIDetectorTest2");
        }
        test.testDetectors();

        System.err.println("JNDIDetectorTest2 DONE");

        System.exit(0);

    }

    private static class TestNetworkRegistry extends NetworkRegistry
    {
        public static NetworkRegistry createNetworkRegistry()
        {
            return new TestNetworkRegistry();
        }
    }

}
