/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.performance;

import test.MultipleTestRunner;
import test.OnewayInvokerClientTest;

/**
 * Makes oneway (client side thread pooling) call a number of times using multiple threads
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class ClientOnewayInvocationTest extends OnewayTest
{
   public ClientOnewayInvocationTest(String name)
   {
      super(name);
   }

   public ClientOnewayInvocationTest(int numberOfInstances)
   {
      super(numberOfInstances);
   }

   public ClientOnewayInvocationTest(String transport, int port)
   {
      super(transport, port);
   }

   public ClientOnewayInvocationTest(String transport, int port, int numberOfInstances)
   {
      super(transport, port, numberOfInstances);
   }

   protected void printStartMessage()
   {
      System.out.println("\n*****************************************************\n" +
            "Starting oneway preformance test with client oneway.\n" +
            "*****************************************************\n");
   }

   protected Runnable getRunner(String method)
   {
      return new ClientRunner(method);
   }

   public void testOnewayServerInvocation() throws Throwable
   {
      //NO OP since don't want to run this one in this case
   }


   public class ClientRunner implements Runnable
   {
      private String method;

      public ClientRunner(String method)
      {
         this.method = method;
      }

      public void run()
      {
         for (int i = 0; i < NUM_OF_CALLS; i++)
         {
            try
            {
               superMakeClientOnewayInvocation(this.method, String.valueOf(incrementCallCount()));
            }
            catch (Throwable throwable)
            {
               throwable.printStackTrace();
            }
         }
      }

   }

   public static void main(String[] args)
   {
      ClientOnewayInvocationTest client = null;
      if (args.length == 1)
      {
         int instances = Integer.parseInt(args[0]);
         client = new ClientOnewayInvocationTest(instances);
      }
      else if (args.length == 2)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         client = new ClientOnewayInvocationTest(transport, port);
      }
      else if (args.length == 3)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         int instances = Integer.parseInt(args[2]);
         client = new ClientOnewayInvocationTest(transport, port, instances);
      }
      else
      {
         client = new ClientOnewayInvocationTest(OnewayInvokerClientTest.class.getName());
         System.out.println("Using default transport (" + client.getTransport() +
               ") and default port (" + client.getPort() + ") and " +
               "default number of instances (" + client.getNumberOfInstances() + ")" +
               "\nCan enter transport, port, and instances via command line.");
      }

      try
      {
         //regular class run
         //client.runInvokers();
         MultipleTestRunner runner = new MultipleTestRunner();
         runner.doRun(client, true);
      }
      catch (Throwable e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

}