/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package test.performance;

import test.OnewayInvokerClientTest;

/**
 * Makes oneway call a number of times using multiple threads
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public abstract class OnewayTest extends OnewayInvokerClientTest
{
   public static final int NUM_OF_THREADS = 5;
   public static final int NUM_OF_CALLS = 40;

   private final Object waitObj = new Object();
   private int callCount = 0;

   public OnewayTest(String name)
   {
      super(name);
   }

   public OnewayTest(int numberOfInstances)
   {
      super(numberOfInstances);
   }

   public OnewayTest(String transport, int port)
   {
      super(transport, port);
   }

   public OnewayTest(String transport, int port, int numberOfInstances)
   {
      super(transport, port, numberOfInstances);
   }

   protected int incrementCallCount()
   {
      int currentCount = callCount++;
      if ((currentCount % 100) == 0)
      {
         System.out.println("call count: " + currentCount);
      }
      if (callCount == (NUM_OF_THREADS * NUM_OF_CALLS))
      {
         synchronized (waitObj)
         {
            waitObj.notify();
         }
      }
      return currentCount;
   }

   protected void setCallCount(int count)
   {
      this.callCount = count;
   }

   protected void makeClientOnewayInvocation(String method, String param) throws Throwable
   {
      makeOnewayInvocation(method, param);
   }

   protected void makeServerOnewayInvocation(String method, String param) throws Throwable
   {
      makeOnewayInvocation(method, param);
   }

   protected void superMakeClientOnewayInvocation(String method, String param) throws Throwable
   {
      super.makeClientOnewayInvocation(method, param);
   }

   protected void superMakeServerOnewayInvocation(String method, String param) throws Throwable
   {
      super.makeServerOnewayInvocation(method, param);
   }

   protected void makeOnewayInvocation(String method, String param) throws Throwable
   {
      callCount = 0;

      sendTotalCount();

      printStartMessage();

      long startTime = System.currentTimeMillis();

      System.out.println("Start time: " + startTime);

      for (int x = 0; x < NUM_OF_THREADS; x++)
      {
         if ((NUM_OF_THREADS % 10) == 0)
         {
            System.out.println("started " + x + " threads");
         }
         new Thread(getRunner(method)).start();
      }

      synchronized (waitObj)
      {
         try
         {
            waitObj.wait(5 * 60 * 1000); // timeout if not notified
         }
         catch (InterruptedException e)
         {

         }
      }

      long endTime = System.currentTimeMillis();

      System.out.println("End time: " + endTime);
      System.out.println("Total number of calls: " + callCount);
      System.out.println("Total time: " + (endTime - startTime));

      int svrTotalCount = getServerTotalCount();

      System.out.println("Server total count: " + svrTotalCount);
      assertEquals(callCount , svrTotalCount);
   }

   private int getServerTotalCount()
   {
      int svrCount = 0;

      try
      {
         Object ret = makeInvocation("serverTotalCallCount", null);
         if(ret != null && ret instanceof String)
         {
            svrCount = Integer.parseInt((String)ret);
         }
      }
      catch (Throwable throwable)
      {
         throwable.printStackTrace();
      }
      return svrCount;
   }

   protected abstract Runnable getRunner(String method);

   protected abstract void printStartMessage();

   /**
    * Used to tell the test server handler the number of calls to expect.
    */
   private void sendTotalCount() throws Throwable
   {
      makeInvocation("totalCallCount", String.valueOf(NUM_OF_CALLS * NUM_OF_THREADS));
   }

}