/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting;

import org.apache.log4j.Level;

/**
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public abstract class AbstractInvokerTest extends DistributedTest
{
   protected int port = 8081;
   protected String transport = "socket";

   public AbstractInvokerTest(String name)
   {
      super(name);
      setLogging();
   }

   public AbstractInvokerTest(String name, String transport, int port)
   {
      super(name);
      this.transport = transport;
      this.port = port;
      //setLogging();
   }

   private void setLogging()
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);
   }

   public String getTransport()
   {
      return transport;
   }

   public int getPort()
   {
      return port;
   }
}
