/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting;

import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.InvocationRequest;

import java.util.List;
import java.rmi.server.UID;

/**
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class MockInvokerCallbackHandler implements InvokerCallbackHandler
{
    private String callbackId;

    public MockInvokerCallbackHandler(String callbackId)
    {
        this.callbackId = callbackId;
    }

    /**
     * Will take the callback message and send back to client.
     * If client locator is null, will store them till client polls to get them.
     *
     * @param invocation
     * @throws Throwable
     */
    public void handleCallback(InvocationRequest invocation)
            throws HandleCallbackException
    {
        System.out.println("We got callback on client.  " + invocation);
    }

    //TODO: Important that client caller keeps id unique and maintains id
    // since used as key when add/remove listener in client subsystem handler -TME
    public String getId()
    {
        return callbackId;
    }

    /**
     * Will get current list of callbacks.
     * @return
     */
    //TODO: This is messed up.  Why should client InvokerCallbackHandler have to implement this?
    // should probably make parent interface that does not have this one -TME
    public List getCallbacks()
    {
        return null;
    }

    /**
     * This method is required to be called upon removing a callback listener
     * so can clean up resources used by the handler.  In particular, should
     * call disconnect on internal Client.
     */
    public void destroy()
    {
    }
}
