package javax.security.auth.x500;

import java.io.InputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/** A noop X500Principal to get some web service stuff to compile under jdk1.3
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.1 $
 */
public final class X500Principal
{
   private byte[] encoded;

   public X500Principal(byte[] name)
   {
      encoded = name;
   }

   public X500Principal(InputStream is)
   {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      byte[] tmp = new byte[1024];
      int count = 0;
      try
      {
         while( (count = is.read(tmp)) > 0 )
         {
            baos.write(tmp, 0, count);
         }
         is.close();
         encoded = baos.toByteArray();
      }
      catch(IOException e)
      {
         throw new IllegalArgumentException("IOException: "+e.getMessage());
      }
   }

   public X500Principal(String name)
   {
   }

   public byte[] getEncoded()
   {
      return encoded;
   }

   public String getName()
   {
      return "X500Principal";
   }

   public String getName(String format)
   {
      return "X500Principal";
   }
}
