/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.security;

import java.security.Principal;
import java.security.AccessController;
import java.security.PrivilegedAction;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision: 1.1.2.1 $</tt>
 */
interface SecurityActions
{
   class UTIL
   {
      static SecurityActions getSecurityActions()
      {
         return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
      }
   }

   SecurityActions NON_PRIVILEGED = new SecurityActions()
   {
      public Principal getPrincipal()
      {
         return SecurityAssociation.getPrincipal();
      }

      public Object getCredential()
      {
         return SecurityAssociation.getCredential();
      }
   };

   SecurityActions PRIVILEGED = new SecurityActions()
   {
      private final PrivilegedAction getPrincipalAction = new PrivilegedAction()
      {
         public Object run()
         {
            return SecurityAssociation.getPrincipal();
         }
      };

      private final PrivilegedAction getCredentialAction = new PrivilegedAction()
      {
         public Object run()
         {
            return SecurityAssociation.getCredential();
         }
      };

      public Principal getPrincipal()
      {
         return (Principal)AccessController.doPrivileged(getPrincipalAction);
      }

      public Object getCredential()
      {
         return AccessController.doPrivileged(getCredentialAction);
      }
   };

   Principal getPrincipal();

   Object getCredential();
}
