
/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */

package org.jboss.deployment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ClassNotFoundException;
import java.util.Collection;
import java.util.Iterator;


/**
 * IncompleteDeploymentException.java
 *
 *
 * Created: Mon Jun 24 08:20:16 2002
 *
 * @author <a href="mailto:d_jencks@users.sourceforge.net">David Jencks</a>
 * @version
 */

public class IncompleteDeploymentException
   extends DeploymentException
{

   private transient final Collection mbeansWaitingForClasses;
   private transient final Collection mbeansWaitingForDepends;
   private transient final Collection rootCause;
   private transient final Collection incompletePackages;
   private transient final Collection waitingForDeployer;

   private String string; //on serialization only this should be transferred

   public IncompleteDeploymentException(final Collection mbeansWaitingForClasses, 
                                        final Collection mbeansWaitingForDepends,
                                        final Collection rootCause,
                                        final Collection incompletePackages,
                                        final Collection waitingForDeployer) 
   {
      if (mbeansWaitingForClasses == null 
          || mbeansWaitingForDepends == null
          || rootCause == null
          ||incompletePackages == null
          || waitingForDeployer == null) 
      {
         throw new IllegalArgumentException("All lists in IncompleteDeploymentException constructor must be supplied");
      } // end of if ()
      
      this.mbeansWaitingForClasses = mbeansWaitingForClasses;
      this.mbeansWaitingForDepends = mbeansWaitingForDepends;
      this.rootCause = rootCause;
      this.incompletePackages = incompletePackages;
      this.waitingForDeployer = waitingForDeployer;
   }


   /**
    * Get the MbeansWaitingForClasses value.
    * @return the MbeansWaitingForClasses value.
    */
   public Collection getMbeansWaitingForClasses()
   {
      return mbeansWaitingForClasses;
   }


   /**
    * Get the MbeansWaitingForDepends value.
    * @return the MbeansWaitingForDepends value.
    */
   public Collection getMbeansWaitingForDepends()
   {
      return mbeansWaitingForDepends;
   }

   /**
    * Get the IncompletePackages value.
    * @return the IncompletePackages value.
    */
   public Collection getIncompletePackages()
   {
      return incompletePackages;
   }


   /**
    * Get the WaitingForDeployer value.
    * @return the WaitingForDeployer value.
    */
   public Collection getWaitingForDeployer()
   {
      return waitingForDeployer;
   }

   public boolean isEmpty()
   {
      return mbeansWaitingForClasses.size() == 0 
         && mbeansWaitingForDepends.size() == 0
         && rootCause.size() == 0
         && incompletePackages.size() == 0
         && waitingForDeployer.size() == 0;
   }

   public String toString()
   {
      //
      // jason: this is a complete mess... should let the catcher format this
      //
      
      if (string != null) 
      {
         return string;
      } // end of if ()
      
      StringBuffer result = new StringBuffer("Incomplete Deployment listing:\n");
      if (waitingForDeployer.size() != 0) 
      {
         result.append("Packages waiting for a deployer:\n");
         appendCollection(result, waitingForDeployer);
      }
      
      if (incompletePackages.size() != 0) 
      {
         result.append("Incompletely deployed packages:\n");
         appendCollection(result, incompletePackages);
      }
      
      if (mbeansWaitingForClasses.size() != 0) 
      {
         result.append("MBeans waiting for classes:\n");
         appendCollection(result, mbeansWaitingForClasses);
      }
      
      if (mbeansWaitingForDepends.size() != 0) 
      {
         result.append("MBeans waiting for other MBeans:\n");
         appendCollection(result, mbeansWaitingForDepends);
      }
      
      if (rootCause.size() != 0) 
      {
         result.append("\nMBEANS THAT ARE THE ROOT CAUSE OF THE PROBLEM:\n");
         appendCollection(result, rootCause);
      }
      
      string = result.toString();
      return string;
   }
      
   private void appendCollection(StringBuffer result, Collection c)
   {
      for (Iterator i = c.iterator(); i.hasNext();)
         result.append(i.next().toString()).append('\n');
   }
   
   private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException
   {
      s.defaultReadObject();
   }

   private void writeObject(ObjectOutputStream s) throws IOException
   {
      toString();
      s.defaultWriteObject();
   }

}
