/*
 *
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.cache.perf.basic;


import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;

import java.io.InputStreamReader;

/**
 * A standalone dummy server that accepts data from other replicated cache.
 */
public class Server
{
   TreeCache cache_;

   void initCach() throws Exception
   {
      cache_ = new TreeCache();
      PropertyConfigurator config = new PropertyConfigurator();
      config.configure(cache_, "META-INF/replSync-service.xml"); // read in generic replAsync xml
      cache_.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
      cache_.startService();
   }

   void destroyCache() throws Exception
   {
      cache_.stopService();
      cache_ = null;
   }

   TreeCache getCache()
   {
      return cache_;
   }

   public static void main(String[] args) throws Exception
   {
      Server server = new Server();
      server.initCach();
      boolean isYes = true;
      InputStreamReader reader = new InputStreamReader(System.in);
      while (isYes) {
         System.out.println("To abort hit cntrl-c");
//            System.out.println(server.getCache().printLockInfo());
         try {
            Thread.sleep(10000);
         } catch (Exception ex) {
         }
         ;
      }
      server.destroyCache();
   }
}
