/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.generic;


import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.GlobalTransaction;
import org.jgroups.stack.IpAddress;

import java.io.*;


/**
 * @author <a href="mailto:bela@jboss.org">Bela Ban</a> Apr 14, 2003
 * @version $Id: GlobalTransactionUnitTestCase.java,v 1.2.2.5 2004/12/30 17:11:54 starksm Exp $
 */
public class GlobalTransactionUnitTestCase extends TestCase {

   public GlobalTransactionUnitTestCase(String name) {
      super(name);
   }

   protected void setUp() throws Exception {
   }

   protected void tearDown() throws Exception {
   }


   public void testEquality() {
      IpAddress a1=new IpAddress("localhost", 4444);
      GlobalTransaction tx1, tx2;

      tx1=GlobalTransaction.create(a1);
      tx2=GlobalTransaction.create(a1);

      System.out.println("\ntx1: " + tx1 + "\ntx2: " + tx2);
      assertTrue(tx1.equals(tx2) == false);

      tx2=tx1;
      assertTrue(tx1.equals(tx2));
   }

   public void testEqualityWithOtherObject() {
      IpAddress a1=new IpAddress("localhost", 4444);
      GlobalTransaction tx1=GlobalTransaction.create(a1);
      System.out.println("\ntx1: " + tx1);
      assertFalse(tx1.equals(Thread.currentThread()));
   }


   public void testExternalization() {
      IpAddress a1=new IpAddress("localhost", 4444);
      IpAddress a2=new IpAddress("localhost", 5555);
      GlobalTransaction tx1, tx2, tx1_copy=null, tx2_copy=null;
      ByteArrayOutputStream bos=null;
      ByteArrayInputStream bis=null;
      ObjectOutputStream out=null;
      ObjectInputStream in=null;
      byte[] buf=null;

      tx1=GlobalTransaction.create(a1);
      tx2=GlobalTransaction.create(a2);

      try {
         bos=new ByteArrayOutputStream(1024);
         out=new ObjectOutputStream(bos);
         out.writeObject(tx1);
         out.writeObject(tx2);
         out.flush();
         buf=bos.toByteArray();
      }
      catch(IOException ex) {
         fail("creation of output stream");
      }

      try {
         bis=new ByteArrayInputStream(buf);
         in=new ObjectInputStream(bis);
         tx1_copy=(GlobalTransaction)in.readObject();
         tx2_copy=(GlobalTransaction)in.readObject();
      }
      catch(IOException ex) {
         fail("creation of input stream");
      }
      catch(ClassNotFoundException e) {
         e.printStackTrace();
         fail();
      }

      System.out.println("\ntx1: " + tx1 + ", tx1_copy: " + tx1_copy +
                         "\ntx2: " + tx2 + ", tx2_copy: " + tx2_copy);

      assertNotNull(tx1_copy);
      assertNotNull(tx2_copy);
      assertEquals(tx1, tx1_copy);
      assertEquals(tx2, tx2_copy);
   }


   public void testWithNullAddress() {
      GlobalTransaction tx1, tx2, tmp_tx1;

      tx1=GlobalTransaction.create(null);
      tx2=GlobalTransaction.create(null);

      tmp_tx1=tx1;
      assertEquals(tx1, tmp_tx1);
      assertTrue(tx1.equals(tx2) == false);
   }


   void sleep(long timeout) {
      try {
         Thread.sleep(timeout);
      }
      catch(InterruptedException e) {
      }
   }

   void log(String msg) {
      System.out.println("-- [" + Thread.currentThread() + "]: " + msg);
   }

   public static Test suite() {
      TestSuite s=new TestSuite(GlobalTransactionUnitTestCase.class);
      return s;
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}
