/*
 *
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.cache.test.local;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.TreeCache;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.logging.Logger;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import java.util.Properties;

/**
 * Checks CRUD methods
 *
 * @author Bela Ban
 * @version $Id: CrudMethodUnitTestCase.java,v 1.1.2.3 2004/12/30 17:11:57 starksm Exp $
 */
public class CrudMethodUnitTestCase extends TestCase {


   public CrudMethodUnitTestCase(String name) {
      super(name);
   }

   public void testCrudMethods() {
      assertTrue(TreeCache.isCrudMethod(TreeCache.putDataEraseMethodLocal));
      assertTrue(TreeCache.isCrudMethod(TreeCache.putDataMethodLocal));
      assertTrue(TreeCache.isCrudMethod(TreeCache.putKeyValMethodLocal));
      assertTrue(TreeCache.isCrudMethod(TreeCache.removeDataMethodLocal));
      assertTrue(TreeCache.isCrudMethod(TreeCache.removeKeyMethodLocal));
      assertTrue(TreeCache.isCrudMethod(TreeCache.removeNodeMethodLocal));

      assertFalse(TreeCache.isCrudMethod(TreeCache.getKeyValueMethodLocal));
      assertFalse(TreeCache.isCrudMethod(TreeCache.getNodeMethodLocal));
      assertFalse(TreeCache.isCrudMethod(TreeCache.getKeysMethodLocal));
      assertFalse(TreeCache.isCrudMethod(TreeCache.getChildrenNamesMethodLocal));
   }



   public static Test suite() throws Exception {
      return new TestSuite(CrudMethodUnitTestCase.class);
   }

   public static void main(String[] args) throws Exception {
      junit.textui.TestRunner.run(suite());
   }


}
