/*
 *
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.local;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.TreeCache;
import org.jboss.cache.lock.IsolationLevel;

/**
 * Unit test for local TreeCache with no tx.
 *
 * @version $Revision: 1.3.2.5 $
 */
public class NoTxUnitTestCase extends TestCase
{
   TreeCache cache;

   public NoTxUnitTestCase(String name)
   {
      super(name);
   }

   public void setUp() throws Exception
   {
      super.setUp();
      cache = new TreeCache();
      cache.setCacheMode(TreeCache.LOCAL);
      cache.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
      cache.createService();
      cache.startService();
   }

   public void tearDown() throws Exception
   {
      super.tearDown();
      cache.stopService();
   }


   public void testPut()
   {
      try {
         cache.put("/a/b/c", "age", new Integer(38));
         assertEquals(cache.get("/a/b/c", "age"), new Integer(38));
         assertNotNull(cache.get("/a/b/c"));
      } catch (Exception e) {
         e.printStackTrace();
         fail(e.toString());
      }
   }

   public void testPutKeys()
   {
      try {
         cache.put("/a/b/c", "age", new Integer(38));
         cache.put("/a/b/c", "name", "Bela");
         assertEquals(cache.get("/a/b/c", "age"), new Integer(38));
         assertNotNull(cache.get("/a/b/c"));
         assertEquals(cache.getKeys("/a/b/c").size(), 2);
         assertEquals(cache.exists("/a/b/c"), true);
      } catch (Exception e) {
         e.printStackTrace();
         fail(e.toString());
      }
   }


   public static Test suite()
   {
      return new TestSuite(NoTxUnitTestCase.class);
   }

   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(suite());
   }


}
