/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.classloader.scoping.naming.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.naming.InitialContext;
import javax.naming.Context;

import org.jboss.test.classloader.scoping.naming.service.BindValue;

/** A servlet that reads the bindings under the shared-context jndi context
 * to test the behavior of jndi lookups across class loading scopes.
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.1 $
 */
public class LookupServlet extends HttpServlet
{
   /**
    *
    * @param servletConfig
    * @throws javax.servlet.ServletException
    */
   public void init(ServletConfig servletConfig) throws ServletException
   {
      super.init(servletConfig);
   }

   protected void doGet(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      processRequest(request, response);
   }

   protected void doPost(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      processRequest(request, response);
   }

   private void processRequest(HttpServletRequest request, HttpServletResponse response)
      throws ServletException, IOException
   {
      response.setContentType("text/html");
      PrintWriter pw = response.getWriter();
      pw.println("<html><head><title>LookupServlet Scoping Test</title></head>");
      pw.println("<body><h1>LookupServlet Scoping Test</h1>");
      pw.println("BindValue.CS: "+BindValue.class.getProtectionDomain().getCodeSource());
      pw.println("<ul>");

      try
      {
         InitialContext ctx = new InitialContext();
         Context testCtx = (Context) ctx.lookup("shared-context");
         Integer count = (Integer) testCtx.lookup("KeyCount");
         for(int n = 0; n < count.intValue(); n ++)
         {
            String key = "Key#" + n;
            BindValue value = (BindValue) testCtx.lookup(key);
            pw.println("\t<li>"+value.getValue()+"</li>");
         }
      }
      catch (Exception e)
      {
         throw new ServletException("Failed to validate shared-context", e);
      }
      pw.println("</ul>");
      pw.println("</body></html>");
   }
}
