/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.classloader.test;

import java.io.File;
import java.net.URL;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.framework.Test;

import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.test.util.ClassMover;
import org.apache.log4j.Logger;

/** Basic tests of the org.jboss.mx.loading.* classes
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.3 $
 */
public class BasicLoaderUnitTestCase extends TestCase
{
   static Logger log = Logger.getLogger(BasicLoaderUnitTestCase.class);

   public BasicLoaderUnitTestCase(String name)
   {
      super(name);
   }

   /** Test the UnifiedLoaderRepository for multi-threaded class loading
    */
   public void testNoClassDefFoundError() throws Exception
   {
      UnifiedLoaderRepository3 ulr = new UnifiedLoaderRepository3();
      String libDir = System.getProperty("jbosstest.deploy.dir");
      File cwd = new File(libDir);
      URL cp = new URL(cwd.toURL(), "../classes");
      log.info("Using cp: " + cp);
      ClassLoader loader = ulr.newClassLoader(cp, true);

      File bakFile = null;
      try
      {
         bakFile = ClassMover.move("org.jboss.test.classloader.test.ex.BaseException");
         loader.loadClass("org.jboss.test.classloader.test.ex.DerivedException");
         fail("Should not have loaded DerivedException");
      }
      catch (NoClassDefFoundError e)
      {
         String msg = e.getMessage();
         log.info("CNFE msg: " + msg, e);
         int index = msg.indexOf("BaseException");
         assertTrue("Saw BaseException in CNFE: (" + index + "), msg=" + msg, index > 0);
      }
      finally
      {
         if (bakFile != null)
            ClassMover.restore(bakFile);
      }

   }

   public void testNoClassDefFoundError2() throws Exception
   {
      UnifiedLoaderRepository3 ulr = new UnifiedLoaderRepository3();
      String libDir = System.getProperty("jbosstest.deploy.dir");
      File cwd = new File(libDir);
      URL cp = new URL(cwd.toURL(), "../classes");
      log.info("Using cp: " + cp);
      ClassLoader loader = ulr.newClassLoader(cp, true);

      File bakFile = null;
      try
      {
         bakFile = ClassMover.move("org.jboss.test.classloader.test.ex.BaseException");
         Class c = loader.loadClass("org.jboss.test.classloader.test.ex.ExThrower");
         c.getMethods();
         fail("Should not have gotten ExThrower methods");
      }
      catch (NoClassDefFoundError e)
      {
         String msg = e.getMessage();
         log.info("CNFE msg: " + msg, e);
         int index = msg.indexOf("BaseException");
         assertTrue("Saw BaseException in CNFE: (" + index + "), msg=" + msg, index > 0);
      }
      finally
      {
         if (bakFile != null)
            ClassMover.restore(bakFile);
      }

   }

   public void testDeadlockScenario1() throws Exception
   {
      String deployDir = System.getProperty("jbosstest.deploy.dir");
      File libDir = new File(deployDir);
      log.info("Using cp: " + libDir);
      DeadlockTests32 test = new DeadlockTests32(libDir);
      test.testDeadLock();
   }

   public void testDeadlockScenario2() throws Exception
   {
      String deployDir = System.getProperty("jbosstest.deploy.dir");
      File libDir = new File(deployDir);
      log.info("Using cp: " + libDir);
      DeadlockTests32 test = new DeadlockTests32(libDir);
      test.testDeadLockAndCircularity();
   }

   public static Test suite()
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new BasicLoaderUnitTestCase("testNoClassDefFoundError"));
      suite.addTest(new BasicLoaderUnitTestCase("testNoClassDefFoundError2"));
      suite.addTest(new BasicLoaderUnitTestCase("testDeadlockScenario1"));
      suite.addTest(new BasicLoaderUnitTestCase("testDeadlockScenario2"));
      return suite;
   }
}
