/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cluster.apache_tomcat;

import junit.framework.Test;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.test.JBossClusteredTestCase;

/**
 * Clustering test case of get/set under scoped class loader.
 *
 * @author Ben Wang
 * @version $Revision: 1.0
 */
public class ScopedTestCase
      extends BaseTest
{
   protected String setUrl;
   protected String getUrl;
   protected String modifyUrl;
   protected String invalidateUrl;

   public ScopedTestCase(String name)
   {
      super(name);
      setUrl = apacheUrl + "/http-scoped/setSession.jsp";
      getUrl = apacheUrl + "/http-scoped/getAttribute.jsp";
      modifyUrl = apacheUrl + "/http-scoped/modifyAttribute.jsp";
      invalidateUrl = apacheUrl + "/http-scoped/invalidateAttribute.jsp";

   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(ScopedTestCase.class,
            "http-scoped.war");
      return t1;
   }

   /**
    * Main method that deals with the Http Session Replication Test
    *
    * @throws Exception
    */
   public void testNonPrimitiveGet()
         throws Exception
   {
      String attr = "";
      getLog().debug("Enter testNonPrimitiveGet");

      getLog().debug(setUrl + ":::::::" + getUrl);

// Create an instance of HttpClient.
      HttpClient client = new HttpClient();

// Set the session attribute first
      HttpMethod m1 = new GetMethod(setUrl);
      makeGet(client, m1);
      sleepThread(4);

// Create a method instance.
      HttpMethod method = new GetMethod(getUrl);
//    Get the Attribute set
      attr = makeGet(client, method);

      restartTomcat(1);

//    Make connection and get
      method = new GetMethod(getUrl);
      String attr2 = makeGet(client, method);
      String tstr = "attr1=" + attr + " and attr2=" + attr2;

      assertEquals("Get attribute should be but is ", attr, attr2);
      getLog().debug("Exit testNonPrimitiveGet");
   }

   /**
    * Test session modify with non-primitive get/modify.
    *
    * @throws Exception
    */
   public void testNonPrimitiveModify()
         throws Exception
   {
      String attr = "";
      getLog().debug("Enter testNonPrimitiveModify");

      getLog().debug(setUrl + ":::::::" + getUrl);

// Create an instance of HttpClient.
      HttpClient client = new HttpClient();

// Set the session attribute first
      HttpMethod m1 = new GetMethod(setUrl);
      makeGet(client, m1);
      sleepThread(4);

// Create a method instance.
      HttpMethod method = new GetMethod(getUrl);
//    Get the Attribute set
      String attrOld = makeGet(client, method);

// Modify a method instance.
      method = new GetMethod(modifyUrl);
//    Get the Attribute set
      makeGet(client, method);
      sleepThread(4);

// Create a method instance.
      method = new GetMethod(getUrl);
//    Get the Attribute set
      attr = makeGet(client, method);

      restartTomcat(1);

//    Make connection and get
      method = new GetMethod(getUrl);
      String attr2 = makeGet(client, method);

      String tstr = "attr1=" + attr + " and attr2=" + attr2;
      String tstr1 = "attrOld=" + attrOld + " and attr=" + attr;

// Check the result
      assertNotSame("Old attribute should be different from new one.",
            attrOld, attr);
      assertEquals("Attributes should be the same", attr, attr2);
      getLog().debug("Exit testNonPrimitiveModify");
   }

   /**
    * Test invalidate session
    *
    * @throws Exception
    */
   public void testInvalidate()
         throws Exception
   {
      String attr = "";
      getLog().debug("Enter testInvalidate");

      getLog().debug(setUrl + ":::::::" + getUrl);

// Create an instance of HttpClient.
      HttpClient client = new HttpClient();

// Set the session attribute first
      HttpMethod m1 = new GetMethod(setUrl);
      makeGet(client, m1);
      sleepThread(4);

// Create a method instance.
      HttpMethod method = new GetMethod(getUrl);
//    Get the Attribute set
      attr = makeGet(client, method);

// Create a method instance.
      method = new GetMethod(invalidateUrl);
//    Get the Attribute set
      makeGet(client, method);
      sleepThread(4);

      restartTomcat(1);

//    Make connection and get
      method = new GetMethod(getUrl);
      String attr2 = makeGet(client, method);

      String tstr = "attr1=" + attr + " and attr2=" + attr2;

// Check the result
      assertNotSame("Old attribute should be different from new one after invalidate.",
            attr, attr2);
      getLog().debug("Exit testInvalidate");
   }


}
