/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cmp2.commerce;

import net.sourceforge.junitejb.EJBTestCase;
import junit.framework.Test;
import org.jboss.test.JBossTestCase;

import javax.naming.InitialContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision: 1.1.2.1 $</tt>
 */
public class LazyResultSetLoadingTest extends EJBTestCase
{
   public static Test suite() throws Exception
   {
      return JBossTestCase.getDeploySetup(CascadeDeleteTest.class, "cmp2-commerce.jar");
   }

   public LazyResultSetLoadingTest(String localName)
   {
      super(localName);
   }

   private OrderHome getOrderHome()
   {
      try
      {
         InitialContext jndiContext = new InitialContext();
         return (OrderHome) jndiContext.lookup("commerce/Order");
      }
      catch(Exception e)
      {
         e.printStackTrace();
         fail("Exception in getOrderHome: " + e.getMessage());
      }
      return null;
   }

   private LineItemHome getLineItemHome()
   {
      try
      {
         InitialContext jndiContext = new InitialContext();
         return (LineItemHome) jndiContext.lookup("commerce/LineItem");
      }
      catch(Exception e)
      {
         e.printStackTrace();
         fail("Exception in getLineItemHome: " + e.getMessage());
      }
      return null;
   }

   public void setUpEJB() throws Exception
   {
      OrderHome oh = getOrderHome();
      Order o = oh.create(new Long(1));

      LineItemHome lih = getLineItemHome();
      LineItem li = lih.create(new Long(11));
      o.getLineItems().add(li);

      li = lih.create(new Long(22));
      o.getLineItems().add(li);

      li = lih.create(new Long(33));
      o.getLineItems().add(li);
   }

   public void tearDownEJB() throws Exception
   {
      getOrderHome().remove(new Long(1));
   }

   public void testLazyResultSetLoading() throws Exception
   {
      final OrderHome oh = getOrderHome();

      // empty result
      Collection col = oh.selectLazy("select object(o) from Address o where o.state='CA'", null);
      assertTrue("Expected empty collection but got " + col.size(), col.isEmpty());

      // collection of results
      col = oh.selectLazy("select object(o) from LineItem o", null);
      assertTrue("Expected 3 line items but got " + col.size(), 3 == col.size());

      Iterator i = col.iterator();
      LineItem removed = (LineItem)i.next();
      i.remove();
      assertTrue("Expected 2 line items but got " + col.size(), 2 == col.size());

      Collection firstPassCol = new ArrayList(2);
      while(i.hasNext())
      {
         firstPassCol.add(i.next());
      }

      Collection secondPassCol = new ArrayList(3);
      i = col.iterator();
      while(i.hasNext())
      {
         final LineItem li = (LineItem)i.next();
         assertTrue(firstPassCol.contains(li));
         secondPassCol.add(li);
      }
      assertTrue("Expected 2 line items but got " + secondPassCol.size(), secondPassCol.size() == 2);
      secondPassCol.add(removed);
      assertTrue("Expected 3 line items but got " + secondPassCol.size(), secondPassCol.size() == 3);

      // limit & offset
      col = oh.selectLazy("select object(o) from LineItem o offset 1 limit 2", null);
      assertTrue("Expected 2 line items but got " + col.size(), col.size() == 2);
      int count = 0;
      for(i = col.iterator(); i.hasNext();)
      {
         i.next();
         ++count;
      }
      assertTrue("Expected 2 but got " + count, count == 2);
   }
}
