/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.test.cmp2.optimisticlock.bug1006723.testentity;


import javax.ejb.EntityBean;
import javax.ejb.CreateException;
import javax.ejb.EntityContext;
import java.util.Collection;
import java.util.Collections;

public abstract class EntityABean implements EntityBean{

	public Long getOID(){
    	return getOIDCMP();
	}

	public void addEntityB(EntityBLocal entityB) throws Exception{
		if (entityB == null)
			throw new Exception("An entity B must be specified.");
		getEntityBsCMR().add(entityB);
	}

	public Collection listEntityBs(){
		return Collections.unmodifiableCollection(getEntityBsCMR());
	}

	public abstract void setOIDCMP(Long oID);

	public abstract Long getOIDCMP();

	public abstract void setEntityBsCMR(Collection entityBs);

	public abstract Collection getEntityBsCMR();

	public Long ejbCreate(Long id) throws CreateException{
		setOIDCMP(id);
		return id;
	}

	public void ejbPostCreate(Long id) throws CreateException{}

	public void ejbActivate(){}

	public void ejbPassivate(){}

	public void ejbLoad(){}

	public void ejbStore(){}

	public void ejbRemove(){}

	public void setEntityContext(EntityContext context){}

	public void unsetEntityContext(){}

}