/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.ha.singleton;

import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import javax.management.Notification;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.DistributedState;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HAPartition.HAMembershipListener;
import org.jboss.ha.framework.interfaces.HAPartition.HAPartitionStateTransfer;
import org.jboss.ha.singleton.HASingletonSupport;
/**
 * 
 * @author  Ivelin Ivanov <ivelin@apache.org>
 *
 */
public class HASingletonSupportTester extends HASingletonSupport
{
   public HAPartition partition = new MyPartition();

   public Stack __invokationStack__ = new Stack();

   public boolean __isDRMMasterReplica__ = false;

   public boolean __isSingletonStarted__ = false;

   protected void setupPartition() throws Exception
   {
      __invokationStack__.push("setupPartition");
   }

   protected void registerRPCHandler()
   {
      __invokationStack__.push("registerRPCHandler");
   }

   protected void unregisterRPCHandler()
   {
      __invokationStack__.push("unregisterRPCHandler");
   }

   protected void registerDRMListener() throws Exception
   {
      __invokationStack__.push("registerDRMListener");
   }

   protected void unregisterDRMListener() throws Exception
   {
      __invokationStack__.push("unregisterDRMListener");
   }

   protected boolean isDRMMasterReplica()
   {
      __invokationStack__.push("isDRMMasterReplica");
      return __isDRMMasterReplica__;
   }

   public void callMethodOnPartition(String methodName, Object[] args) throws Exception
   {
      __invokationStack__.push("callMethodOnCluster:" + methodName);
   }

   public void startSingleton()
   {
      __invokationStack__.push("startSingleton");
   }

   public void stopSingleton()
   {
      __invokationStack__.push("stopSingleton");
   }

   protected void makeThisNodeMaster()
   {
      __invokationStack__.push("makeThisNodeMaster");
      super.makeThisNodeMaster();
   }

   public void sendNotification(Notification notification)
   {
      return;
   }

   public String getServiceHAName()
   {
      return getClass().getName();
   }

   public HAPartition getPartition()
   {
      return partition;
   }
   
   public class MyPartition implements HAPartition
   {
      public void callAsynchMethodOnCluster(String serviceName, String methodName, Object[] args, boolean excludeSelf)
         throws Exception
      {
         throw new UnsupportedOperationException("NYI");
      }

      public void callAsynchMethodOnCluster(String serviceName, String methodName, Object[] args, Class[] types,
         boolean excludeSelf) throws Exception
      {
         __invokationStack__.push("callAsynchMethodOnCluster:" + methodName);
      }

      public ArrayList callMethodOnCluster(String serviceName, String methodName, Object[] args, boolean excludeSelf)
         throws Exception
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public ArrayList callMethodOnCluster(String serviceName, String methodName, Object[] args, Class[] types,
            boolean excludeSelf) throws Exception
      {
         // There are no other members of the cluster
         return null;
      }
      
      public ClusterNode[] getClusterNodes()
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public Vector getCurrentView()
      {
         throw new UnsupportedOperationException("NYI");
      }

      public long getCurrentViewId()
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public DistributedReplicantManager getDistributedReplicantManager()
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public DistributedState getDistributedStateService()
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public String getNodeName()
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public String getPartitionName()
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public void registerMembershipListener(HAMembershipListener listener)
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public void registerRPCHandler(String serviceName, Object handler)
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public void subscribeToStateTransferEvents(String serviceName, HAPartitionStateTransfer subscriber)
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public void unregisterMembershipListener(HAMembershipListener listener)
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public void unregisterRPCHandler(String serviceName, Object subscriber)
      {
         throw new UnsupportedOperationException("NYI");
      }
      
      public void unsubscribeFromStateTransferEvents(String serviceName, HAPartitionStateTransfer subscriber)
      {
         throw new UnsupportedOperationException("NYI");
      }
   }
}