/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.hibernate.ejb;

import org.jboss.test.hibernate.model.User;
import org.jboss.test.hibernate.ProfileService;

import javax.ejb.SessionBean;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import java.rmi.RemoteException;
import java.util.List;

import net.sf.hibernate.HibernateException;

/**
 * An ejb to test the ejb method interception style of transparent
 * session management.
 *
 * @author <a href="mailto:steve@hibernate.org">Steve Ebersole</a>
 * @version $Revision: 1.1.2.1 $
 *
 * @ejb:bean   name="ProfileService"
 *             jndi-name="ProfileService"
 *             view-type="remote"
 *             type="Stateless"
 */
public class ProfileBean implements SessionBean
{
   private ProfileService delegate = new ProfileService();

   /**
    * @exception EJBException if an error occurs
    * @ejb:interface-method
    */
   public User storeUser(User user) throws EJBException
   {
      try
      {
         return delegate.storeUser(user);
      }
      catch(HibernateException e)
      {
         throw new EJBException("Error performing store", e);
      }
   }

   /**
    * @exception EJBException if an error occurs
    * @ejb:interface-method
    */
   public User loadUser(long id) throws EJBException
   {
      try
      {
         return delegate.loadUser(id);
      }
      catch(HibernateException e)
      {
         throw new EJBException("Error performing load", e);
      }
   }

   /**
    * @exception EJBException if an error occurs
    * @ejb:interface-method
    */
   public User loadUser(Long id) throws EJBException
   {
      try
      {
         return delegate.loadUser(id);
      }
      catch(HibernateException e)
      {
         throw new EJBException("Error performing load", e);
      }
   }

   /**
    * @exception EJBException if an error occurs
    * @ejb:interface-method
    */
   public List listUsers() throws EJBException
   {
      try
      {
         return delegate.listUsers();
      }
      catch(HibernateException e)
      {
         throw new EJBException("Error performing list", e);
      }
   }

   /**
    * @ejb:create-method
    */
   public void ejbCreate()
   {
   }

   public void ejbActivate() throws EJBException, RemoteException
   {
   }

   public void ejbPassivate() throws EJBException, RemoteException
   {
   }

   public void ejbRemove() throws EJBException, RemoteException
   {
   }

   public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException
   {
   }
}
