package org.jboss.test.invokers.ejb;

import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.ObjectMessage;
import javax.naming.Context;
import javax.naming.InitialContext;

import org.jboss.logging.Logger;
import org.jboss.test.invokers.interfaces.BusinessObjectLocal;
import org.jboss.test.invokers.interfaces.BusinessObjectLocalHome;

/** An MDB that acts a an async 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1 $
 */
public class JMSGatewayMDB implements MessageDrivenBean, MessageListener
{
   static Logger log = Logger.getLogger(JMSGatewayMDB.class);
   private MessageDrivenContext ctx = null;
   private QueueConnection queConn;
   private QueueSession session;
   private Context enc;

   public void setMessageDrivenContext(MessageDrivenContext ctx)
   {
      this.ctx = ctx;
      try
      {
         InitialContext iniCtx = new InitialContext();
         enc = (Context) iniCtx.lookup("java:comp/env");
         QueueConnectionFactory factory = (QueueConnectionFactory) enc.lookup("jms/ConnectionFactory");
         queConn = factory.createQueueConnection();
         session = queConn.createQueueSession(false, QueueSession.AUTO_ACKNOWLEDGE);
      }
      catch(Exception e)
      {
         log.error("Setup failure", e);
         throw new EJBException("Setup failure", e);
      }
   }
   public void ejbCreate()
   {
   }
   public void ejbRemove() throws EJBException
   {
      try
      {
         if( session != null )
            session.close();
         if( queConn != null )
            queConn.close();
      }
      catch(Exception e)
      {
         log.error("Failed to close JMS resources", e);
      }
   }

   /**
    * 
    * @param message
    */ 
   public void onMessage(Message message)
   {
      log.info("onMessage, msg="+message);
      try
      {
         ObjectMessage objMsg = (ObjectMessage) message;
         Queue replyTo = (Queue) message.getJMSReplyTo();
         String ejbName = message.getStringProperty("ejbName");
         Object[] args = (Object[]) objMsg.getObject();
         Object ref = enc.lookup("ejb/"+ejbName);
         log.info("ejb/"+ejbName+" = "+ref);
         BusinessObjectLocalHome home = (BusinessObjectLocalHome) ref;
         BusinessObjectLocal bean = home.create();
         String reply = bean.doSomethingSlowly(args[0], (String) args[1]);
         reply = reply + "viaJMSGatewayMDB";
         sendReply(reply, replyTo);
      }
      catch(Exception e)
      {
         log.error("onMessage failure", e);
      }
   }

   private void sendReply(String reply, Queue replyTo) throws JMSException
   {
      QueueSender sender = session.createSender(replyTo);
      Message replyMsg = session.createObjectMessage(reply);
      sender.send(replyMsg);
   }
}
