/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: JBossNetTestBase.java,v 1.1.4.2 2004/12/02 11:40:10 tdiesler Exp $

package org.jboss.test.jbossnet;

import org.apache.axis.client.AxisClient;
import org.apache.axis.client.ServiceFactory;
import org.apache.axis.configuration.FileProvider;
import org.jboss.test.JBossTestCase;

import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import java.net.URL;

/**
 * Junit Test class with some JBoss.Net support
 * <br>
 * @since 12. Oktober 2001, 11:20
 * @author Thomas.Diesler@jboss.org
 */
public abstract class JBossNetTestBase extends JBossTestCase
{
   /** the protocol we use */
   protected String PROTOCOL = "http://";

   /** the address to which we forward the request */
   protected String ADDRESS = "" + getServerHost() + ":8080/";

   /** where the axis servlet context is installed */
   protected String AXIS_CONTEXT = ADDRESS + "jboss-net/";

   /** where the service port is located under */
   protected String SERVICE_PORT = AXIS_CONTEXT + "services";

   /** has an associated end point that may be configured once */
   protected String SERVICES_LOCATION = PROTOCOL + SERVICE_PORT;

   /** Creates new JBossNetTestBase */
   public JBossNetTestBase(String name)
   {
      super(name);
   }

   /** Create a Service that is preconfigured from WSDL
    */
   public Service createService(URL wsdlURL, QName serviceQName) throws Exception
   {
      // Note, we cannot use javax.xml.rpc.ServiceFactory.newFactory()
      ServiceFactory factory = new org.apache.axis.client.ServiceFactory();
      Service service = factory.createService(wsdlURL, serviceQName);

      // configure the client engine
      String config = getAxisConfiguration();
      AxisClient clientEngine = new AxisClient(new FileProvider(config));
      ((org.apache.axis.client.Service)service).setEngine(clientEngine);

      return service;
   }

   /** Create a Service that is preconfigured from WSDL
    */
   public Service createService(URL wsdlURL, QName serviceQName, boolean maintainSession) throws Exception
   {
      Service service = createService(wsdlURL, serviceQName);
      ((org.apache.axis.client.Service)service).setMaintainSession(maintainSession);
      return service;
   }

   /** Overwrite to provide the path to the custom client config */
   protected String getAxisConfiguration()
   {
      return "client-config.wsdd";
   }
}
