package org.jboss.test.jbossnet.admindevel;

import junit.framework.Test;
import org.jboss.test.JBossTestCase;

/** A test for the examples from the JBoss Admin Devel book.
 *
 * @author Thomas.Diesler@jboss.org
 * @version $Revision: 1.1.4.1 $
 */
public class ExampleTestCase extends JBossTestCase
{
   private Hello helloPort;

   public ExampleTestCase(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      HelloServiceLocator locator = new HelloServiceLocator();
      helloPort = locator.getHello();
   }

   public void testHelloString() throws Exception
   {
      String retStr = helloPort.helloString("Kermit");
      assertEquals("Hello Kermit!", retStr);
   }

   public void testHelloBean() throws Exception
   {
      HelloObj ho = new HelloObj("Kermit");
      HelloReplyObj hro = helloPort.helloBean(ho);
      assertEquals("Hello Kermit!", hro.getMsg());
   }

   public void testHelloArray() throws Exception
   {
      HelloObj[] query = new HelloObj[3];
      HelloObj ho = new HelloObj();
      ho.setMsg("Kermit");
      query[0] = ho;
      ho = new HelloObj();
      ho.setMsg("Piggy");
      query[1] = ho;
      ho = new HelloObj();
      ho.setMsg("Fozzy");
      query[2] = ho;

      Object[] reply = helloPort.helloArray(query);
      for (int i = 0; i < reply.length; i++)
      {
         HelloReplyObj replyObj = (HelloReplyObj)reply[i];
         assertEquals("Hello " + query[i].getMsg() + "!", replyObj.getMsg());
      }
   }

   /** Deploy the test ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(ExampleTestCase.class, "jbossnet-admindevel.ear");
   }

}
