/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.jbossnet.ejbsimple.server;

import javax.ejb.EJBException;

import org.jboss.test.util.ejb.SessionSupport;

import org.jboss.test.jbossnet.ejbsimple.HelloData;
import org.w3c.dom.Element;

/**
 * The typical Hello Session Bean this time
 * as a web-service.
 * @author jung
 * @version $Revision: 1.1.1.1.4.1 $
 * @ejb.bean name="HelloRemote"
 *           display-name="Hello World Bean Remote"
 *           type="Stateless"
 *           view-type="remote"
 *           jndi-name="hello/HelloRemote"
 * @ejb.transaction type="Required"
 * @jboss-net.web-service urn="HelloRemote"
 * @ejb.interface remote-class="org.jboss.test.jbossnet.ejbsimple.HelloRemote" extends="javax.ejb.EJBObject"
 * @ejb.home remote-class="org.jboss.test.jbossnet.ejbsimple.HelloRemoteHome" extends="javax.ejb.EJBHome"
 */

public class HelloRemoteBean
   extends SessionSupport
   implements javax.ejb.SessionBean {
   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="remote"
    */

   public String hello(String name) {
      return "Hello " + name + "!";
   }

   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="remote"
    */

   public String howdy(HelloData name) {
      return "Howdy " + name.getName() + "!";
   }

   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="remote"
    */

   public void throwException() {
      throw new EJBException("Something went wrong");
   }

   /**
    * @jboss-net:web-method
    * @ejb:interface-method view-type="remote"
    */
   public Object[] arrays(Object[] values) {
      return values;
   }

   /**
    * @jboss-net:web-method
    * @ejb:interface-method view-type="remote"
    */
   public Object[] reverse(Object[] values) {
      Object[] result = new Object[values.length];
      for (int i = 0; i < values.length; ++i)
         result[i] = values[values.length - i - 1];
      return result;
   }

   /**
    * @jboss-net:web-method
    * @ejb:interface-method view-type="both"
    */
   public HelloData[] typedArrays(HelloData[] values) {
      return values;
   }
   
   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="both"
    */

   public Element element(Element in) {
      return in;
   }
   
}
