package org.jboss.test.jbossnet.jmx.server;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;

/**
 * A test dynamic mbean that will be provided as a web-service
 * @jmx.mbean name="jboss.net:service=JMXDynamicTestMBean"
 * @jboss-net.web-service urn="JMXDynamicTest" expose-all="true"
 * @author jung
 * @version $Revision: 1.1.1.1.4.1 $
 * @since 18.02.04
 */

public class JMXDynamicTest implements DynamicMBean
{

   /* Member variables */
   private String testString = "JMX_TEST_STRING";

   /* (non-Javadoc)
    * @see javax.management.DynamicMBean#getAttribute(java.lang.String)
    */
   public Object getAttribute(String attribute)
      throws AttributeNotFoundException, MBeanException, ReflectionException
   {
      return testString;
   }

   /* (non-Javadoc)
    * @see javax.management.DynamicMBean#setAttribute(javax.management.Attribute)
    */
   public void setAttribute(Attribute attribute)
      throws
         AttributeNotFoundException,
         InvalidAttributeValueException,
         MBeanException,
         ReflectionException
   {
      testString = (String) attribute.getValue();
   }

   /* (non-Javadoc)
    * @see javax.management.DynamicMBean#getAttributes(java.lang.String[])
    */
   public AttributeList getAttributes(String[] attributes)
   {
      return null;
   }

   /* (non-Javadoc)
    * @see javax.management.DynamicMBean#setAttributes(javax.management.AttributeList)
    */
   public AttributeList setAttributes(AttributeList attributes)
   {
      return null;
   }

   /* (non-Javadoc)
    * @see javax.management.DynamicMBean#invoke(java.lang.String, java.lang.Object[], java.lang.String[])
    */
   public Object invoke(String actionName, Object[] params, String[] signature)
      throws MBeanException, ReflectionException
   {
      return null;
   }

   /* (non-Javadoc)
    * @see javax.management.DynamicMBean#getMBeanInfo()
    */
   public MBeanInfo getMBeanInfo()
   {
      MBeanAttributeInfo[] attrs =
         new MBeanAttributeInfo[] {
             new MBeanAttributeInfo(
               "TestString",
               "java.lang.String",
               "shit",
               true,
               true,
               false)};
      MBeanOperationInfo[] ops =
         new MBeanOperationInfo[] {
             new MBeanOperationInfo(
               "noopOperation",
               "shit",
               new MBeanParameterInfo[0],
               "void",
               MBeanOperationInfo.UNKNOWN)};
      MBeanInfo result =
         new MBeanInfo(
            getClass().getName(),
            "shit",
            attrs,
            new MBeanConstructorInfo[0],
            ops,
            new MBeanNotificationInfo[0]);
      return result;
   }
}
